/******************************************************************************
#ifdef	DOC
  File Name		: adeca_bridge_data_adsp.h
  Description	:
  Remark		:
  Date			: 2010/11/25
  Copyright		: Panasonic Corporation.
  %Id:
#endif
 *****************************************************************************/
#ifndef _MN2WS0270_ADECA_BRIDGE_DATA_ADSP_H_
#define _MN2WS0270_ADECA_BRIDGE_DATA_ADSP_H_


#include "adeca_bridge_data_host.h"


typedef struct {
	int	error;
	struct {
		ADECA_ucode_ver_t	info;
	} args;
} adeca_get_dsp_ucodever_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_dsp_state_t	stat;
	} args;
} adeca_get_dsp_state_arg_t;


typedef struct {
	int	error;
	struct {
		ADECA_dsp_bypass_t	func;
	} args;
} adeca_set_dsp_bypass_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		ADECA_dsp_path_t	path;
	} args;
} adeca_select_dsp_outport_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		UH					gain;
	} args;
} adeca_set_dsp_inputtrim_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		ADECA_dsp_hpf_t		hpf;
	} args;
} adeca_set_dsp_hpf_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		UH					gain;
	} args;
} adeca_set_dsp_gainadj_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		UH					low_gain;
		UH					high_gain;
	} args;
} adeca_set_dsp_tone_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		UH					lch_gain;
		UH					rch_gain;
	} args;
} adeca_set_dsp_balance_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_dsp_vol_t			gain;
	} args;
} adeca_set_dsp_volume_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		UH					delay;
	} args;
} adeca_set_dsp_lipsync_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t			dst;
		UH					lch_gain;
		UH					rch_gain;
	} args;
} adeca_set_dsp_outputtrim_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_dsp_mute_t	onoff;
	} args;
} adeca_set_dsp_mute_arg_t;

typedef struct {
	int	error;
	struct {
		UH	vol;
	} args;
} adeca_set_dsp_slew_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
		UH gain;
	} args;
} adeca_set_dsp_clipper_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
		ADECA_dsp_drc_t drc;
	} args;
} adeca_set_dsp_drc_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t 	  dst;
		ADECA_dsp_equalizer_t eq;
	} args;
} adeca_set_dsp_equalizer_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
		ADECA_dsp_spv_t spv;
	} args;
} adeca_set_dsp_spv_arg_t;

typedef struct {
	int	error;
	struct {
		UH lch_gain;
		UH rch_gain;
	} args;
} adeca_set_dsp_monomix_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
	    UH freq;
	} args;
} adeca_set_dsp_lpf_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
	    UB freq;
	} args;
} adeca_set_dsp_dccut_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
		ADECA_dsp_srs_t srs;
	} args;
} adeca_set_dsp_srs_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
		ADECA_dsp_limit_t limit;
	} args;
} adeca_set_dsp_limit_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t dst;
		ADECA_dsp_avc_t avc;
	} args;
} adeca_set_dsp_avc_arg_t;

typedef struct {
	int	error;
	struct {
		UB onoff;
	} args;
} adeca_set_dsp_subwoofer_arg_t;

#endif /* #ifndef _MN2WS0270_ADECA_BRIDGE_DATA_ADSP_H_ */
